<?php
/**
 * Class that operate on table 'onlinetempproduct'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2019-11-16 10:42
 */
class OnlinetempproductMySqlDAO implements OnlinetempproductDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return OnlinetempproductMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM onlinetempproduct WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM onlinetempproduct';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM onlinetempproduct ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param onlinetempproduct primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM onlinetempproduct WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param OnlinetempproductMySql onlinetempproduct
 	 */
	public function insert($onlinetempproduct){
		$sql = 'INSERT INTO onlinetempproduct (productid, edited, sysdate, userid) VALUES (?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($onlinetempproduct->productid);
		$sqlQuery->setNumber($onlinetempproduct->edited);
		$sqlQuery->set($onlinetempproduct->sysdate);
		$sqlQuery->setNumber($onlinetempproduct->userid);

		$id = $this->executeInsert($sqlQuery);	
		$onlinetempproduct->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param OnlinetempproductMySql onlinetempproduct
 	 */
	public function update($onlinetempproduct){
		$sql = 'UPDATE onlinetempproduct SET productid = ?, edited = ?, sysdate = ?, userid = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($onlinetempproduct->productid);
		$sqlQuery->setNumber($onlinetempproduct->edited);
		$sqlQuery->set($onlinetempproduct->sysdate);
		$sqlQuery->setNumber($onlinetempproduct->userid);

		$sqlQuery->setNumber($onlinetempproduct->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM onlinetempproduct';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByProductid($value){
		$sql = 'SELECT * FROM onlinetempproduct WHERE productid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByEdited($value){
		$sql = 'SELECT * FROM onlinetempproduct WHERE edited = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryBySysdate($value){
		$sql = 'SELECT * FROM onlinetempproduct WHERE sysdate = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByUserid($value){
		$sql = 'SELECT * FROM onlinetempproduct WHERE userid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByProductid($value){
		$sql = 'DELETE FROM onlinetempproduct WHERE productid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByEdited($value){
		$sql = 'DELETE FROM onlinetempproduct WHERE edited = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteBySysdate($value){
		$sql = 'DELETE FROM onlinetempproduct WHERE sysdate = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByUserid($value){
		$sql = 'DELETE FROM onlinetempproduct WHERE userid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return OnlinetempproductMySql 
	 */
	protected function readRow($row){
		$onlinetempproduct = new Onlinetempproduct();
		
		$onlinetempproduct->id = $row['id'];
		$onlinetempproduct->productid = $row['productid'];
		$onlinetempproduct->edited = $row['edited'];
		$onlinetempproduct->sysdate = $row['sysdate'];
		$onlinetempproduct->userid = $row['userid'];

		return $onlinetempproduct;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return OnlinetempproductMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>